<?php
class Application_Model_Helpers_UserHelper {
	
	var $db;
	public function __construct() {
		$this->db = Zend_Registry::get(DATABASE_SCHEMA);
	}
	
	private function hashed($str) {
		return strrev(strtoupper(sha1($str)));
	}
	
	private function isEmailExists($data) {
		/*
		$data['id'] => User ID (0 for new account)		
		$data['email'] => Email ID
		*/
		
		if($data['id']==0) {
			$sql = "SELECT COUNT(`user_email`) AS `cntEmail` FROM ".DB_PREFIX."users WHERE `user_email`='".trim($data['email'])."'";
		} else {
			$sql = "SELECT COUNT(`user_email`) AS `cntEmail` FROM ".DB_PREFIX."users WHERE `user_email`='".trim($data['email'])."' AND `user_id`!=".$data['id'];
		}
		$rs = $this->db->query$($sql)->fetch();
		if($rs['cntEmail']==0) {
			return false; //Email does not exist
		} else {
			return true; //Email exists
		}
	}
	
	public function getCountries() {
		$sql = "SELECT * FROM `".DB_PREFIX."countries` WHERE `country_status`=1 ORDER BY `country_name`";
		return $this->db->query$($sql)->fetchAll();
	}
	
	public function register($data) {
		/*	
		$data['fname'] => First Name
		$data['mname'] => Middle Name
		$data['lname'] => Last Name
		$data['email'] => Email ID
		$data['pass'] => Password (Plain Text)
		$data['country'] => Country ID
		$data['dob'] => Date of Birth (yyyy-mm-dd format)
		*/
		
		if($this->isEmailExists(array('email'=>$data['email'], 'id'=>0))) {
			$arr = array('code' => -1, 'msg' => 'This Email ID already exists. Please try another.');
		} else {
			$sql = "INSERT INTO ".DB_PREFIX."users (`user_fname`, `user_mname`, `user_lname`, `user_email`, `user_password`, `user_dob`, `user_country_id`) VALUES ('".
					addslashes(trim($data['fname']))."', '".addslashes(trim($data['mname']))."', '".addslashes(trim($data['lname']))."', '".addslashes(trim($data['email']))."', 
					'".$this->hashed(trim($data['pass']))."', '".$data['dob']."', ".$data['country'].")";
			if($this->db->query($sql)) {
				$arr = array('code' => 1, 'msg' => 'You have been registered successfully. Please check your email and activate your account.');
				$this->sendRegisterEmail($data);
			} else {
				$arr = array('code' => -2, 'msg' => 'We are unable to register you at the moment. Please try again later.');
			}
		}
		return $arr;
	}
	
	public function login($data) {
		/*
		$data['email'] => Registered Email ID
		$data['pass'] => Password (plain text)
		*/
		$arr = array();
		$sql = "SELECT * FROM ".DB_PREFIX."users WHERE `user_email`='".trim($data['email'])."' AND `user_password`='".$this->hashed(trim($data['pass']))."'";
		$rsUser = $this->db->query($sql)->fetch();
		
		if(!$rsUser) {
			$arr['code'] = -1;
			$arr['msg'] = "Invalid Username and/or Password. Please try again.";
		} else {
			if($rsUser['user_status']==0) {
				$arr['code'] = -2;
				$arr['msg'] = "Your user account is currently not activated. Please activate your account or contact the administrator.";
			} else {
				$arr['code'] = 1;
				$arr['msg'] = "You are authenticated. Logging in...";
			}
		}
		return $arr;
	}
	
	public function logout($userID) {
		/*
		$userID => User ID
		*/
		
		$sql = "UPDATE ".DB_PREFIX."users SET `user_auth_key`='' WHERE `user_id`=".$userID;
		$this->db->query($sql);
	}
	
	public function forgotpassword($email) {
		/*
		$email => Registered Email ID
		*/
		
		$sql = "SELECT * FROM ".DB_PREFIX."users `user_email`='".trim($email)."'";
		$rsUser = $this->db->query($sql)->fetch();
		
		if(!$rsUser) {
			$arr = array('code' => -1, 'msg' => 'The Email ID you provided is not registered with us. Please try again.');
		} else {
			$mailReply = $this->sendForgotPasswordEmail($rsUser);
			if($mailReply) {
				$arr = array('code' => 1, 'msg' => 'Please check your email to reset your password.');
			} else {
				$arr = array('code' => -2, 'msg' => 'There are some technical issues. Please try again later.');
			}
		}
		return $arr;
	}
	
	public function changepassword($data) {
		/*
		$data['id'] => User ID
		$data['new'] => New Password (Plain Text)
		$data['conf'] => Confirm New Password (Plain Text)
		$data['old'] => Old Password (Plain Text)
		*/
		
		$sql = "SELECT * FROM ".DB_PREFIX."users `user_id`=".$data['id'];
		$rsUser = $this->db->query($sql)->fetch();
		
		if($rsUser['user_password']!=$this->hashed(trim($data['old']))) { //Incorrect Old Password
			$arr = array('code' => -1, 'msg' => 'The Old Password you provided is incorrect. Please try again.');
		} else {
			if($this->hashed(trim($data['new']))!=$this->hashed(trim($data['conf']))) { //Both New Passwords are not same
				$arr = array('code' => -2, 'msg' => 'The New Password you provided is not the same as the Confirmation Password. Please try again.');
			} else { //Everything fine, change the password
				$sql = "UPDATE ".DB_PREFIX."users SET `user_password`='".$this->hashed(trim($data['new']))."' WHERE `user_id`=".$data['id'];
				$this->db->query($sql);
				$arr = array('code' => 1, 'msg' => 'Password changed successfully.');
			}
		}
		return $arr;
	}
	
	private function sendRegisterEmail($data) {
		return true;
	}
	
	private function sendForgotPasswordEmail($data) {
		return true;
	}
}
?>