<?php
class Admin_ActivitiesController extends Zend_Controller_Action {   
	public function init() {		
		session_start();
		$this->_helper->layout->setLayout('layout-admin');	
	}	
	public function checkActhentication() {
		if(!isset($_SESSION['s_authInfo'])) {
			$this->_redirect('/admin/index');	
		}
	}
		
	/** Manage Activity Category Starts **/
	public function activitycategoriesAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		$this->view->activitycatList = $dbHelper->getActivityCategories();
		$this->view->selectedItem = 'itemActivities';
		$this->view->pageTitle = '<i class="fa fa-trophy"></i> Activities';
	}
	
	public function addactivitycategoryAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		$this->view->selectedItem = 'itemActivities';
		$this->view->pageTitle = '<i class="fa fa-trophy"></i> Activities';
		
		if($this->getRequest()->isPost()) {
			$catName = trim($this->getRequest()->getPost('txtCatName'));
			$this->view->addResult = $dbHelper->addActivityCategory($catName);	
			$this->view->selectedItem = 'itemActivities';
		}
	}
	
	public function deleteactivitycategoryAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();	
		
		$this->_helper->layout()->disableLayout();
	    $this->_helper->viewRenderer->setNoRender(true);
		
		$catID = $this->getRequest()->getParam('catID');
		echo $dbHelper->deleteActivityCategory($catID);
	}	
	
	public function editactivitycategoryAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		$this->view->selectedItem = 'itemActivities';
		$this->view->pageTitle = '<i class="fa fa-trophy"></i> Activities';
		
		if($this->getRequest()->isPost()) {
			$catName = trim($this->getRequest()->getPost('txtCatName'));
			$catID = trim($this->getRequest()->getPost('hdnCatID'));
			$this->view->editResult = $dbHelper->updateActivityCategory($catName, $catID);				
		} else {
			$catID = $this->getRequest()->getParam('catID');
			$this->view->activityCategory = $dbHelper->getActivityCategory($catID);	
		}
	}
	/** Manage Activity Category Ends **/
	
	/** Manage activities Starts **/
	public function activitiesAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		$this->view->activitycatList = $dbHelper->getActivities();
		$this->view->selectedItem = 'itemActivities';
		$this->view->pageTitle = '<i class="fa fa-trophy"></i> Activities';
	}
	
	public function addactivitiesAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		
		$this->view->selectedItem = 'itemActivities';
		$this->view->pageTitle = '<i class="fa fa-trophy"></i> Activities';
		
		$this->view->activityCategoryRec = $dbHelper->getActivityCategories();
		$this->view->ageGroups = $dbHelper->getAgeGroups();
		$this->view->topics = $dbHelper->getTopic();
		if($this->getRequest()->isPost()) {
			$catID = trim($this->getRequest()->getPost('catID'));
			$agegroupID = trim($this->getRequest()->getPost('agegroupID'));
			$topicID = trim($this->getRequest()->getPost('topicID'));
			$actTitle = trim($this->getRequest()->getPost('actTitle'));
			$actShortdesc = trim($this->getRequest()->getPost('actShortdesc'));
			$actLongdesc = trim($this->getRequest()->getPost('actLongdesc'));
			$actstatus = trim($this->getRequest()->getPost('actstatus'));
			
			$this->view->addResult = $dbHelper->addActivities($catID,$agegroupID,$topicID,$actTitle,$actShortdesc,$actLongdesc,$actstatus);	
		}
	}
	
	public function deleteactivitiesAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();	
		
		$this->_helper->layout()->disableLayout();
	    $this->_helper->viewRenderer->setNoRender(true);
		
		$catID = $this->getRequest()->getParam('catID');
		echo $dbHelper->deleteActivityCategory($catID);
	}	
	
	public function editactivitiesAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		$this->view->selectedItem = 'itemActivities';
		$this->view->pageTitle = '<i class="fa fa-trophy"></i> Activities';
		
		if($this->getRequest()->isPost()) {
			$catID = trim($this->getRequest()->getPost('catID'));
			$agegroupID = trim($this->getRequest()->getPost('agegroupID'));
			$topicID = trim($this->getRequest()->getPost('topicID'));
			$actTitle = trim($this->getRequest()->getPost('actTitle'));
			$actShortdesc = trim($this->getRequest()->getPost('actShortdesc'));
			$actLongdesc = trim($this->getRequest()->getPost('actLongdesc'));
			$actstatus = trim($this->getRequest()->getPost('actstatus'));
			
			$actID = trim($this->getRequest()->getPost('hdnID'));
			$this->view->editResult = $dbHelper->updateActivities($catID,$agegroupID,$topicID,$actTitle,$actShortdesc,$actLongdesc,$actstatus, $actID);	
			
		} else {
			$catID = $this->getRequest()->getParam('activityID');
			$this->view->activityCategory = $dbHelper->getActivityByID($catID);	
			$this->view->activityCategoryRec = $dbHelper->getActivityCategories();
			$this->view->ageGroups = $dbHelper->getAgeGroups();
			$this->view->topics = $dbHelper->getTopic();
		}
	}	
	/** Manage activities Ends **/
		
	/** Manage Topic Starts **/
	public function topicAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		$this->view->activitycatList = $dbHelper->getTopic();
		$this->view->selectedItem = 'itemActivities';
		$this->view->pageTitle = '<i class="fa fa-trophy"></i> Activities';
	}
	
	public function addtopicAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		$this->view->selectedItem = 'itemActivities';
		$this->view->pageTitle = '<i class="fa fa-trophy"></i> Activities';
		
		if($this->getRequest()->isPost()) {
			$txtTopic = trim($this->getRequest()->getPost('txtTopic'));
			$this->view->addResult = $dbHelper->addTopic($txtTopic);				
		}
	}
	
	public function deletetopicAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();	
		
		$this->_helper->layout()->disableLayout();
	    $this->_helper->viewRenderer->setNoRender(true);
		
		$catID = $this->getRequest()->getParam('catID');
		echo $dbHelper->deleteActivityCategory($catID);
	}	
	
	public function edittopicAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		$this->view->selectedItem = 'itemActivities';
		$this->view->pageTitle = '<i class="fa fa-trophy"></i> Activities';
		
		if($this->getRequest()->isPost()) {
			$catName = trim($this->getRequest()->getPost('txtTopicName'));
			$catID = trim($this->getRequest()->getPost('hdnID'));
			$this->view->editResult = $dbHelper->updateTopic($catName, $catID);				
		} else {
			$topicID = $this->getRequest()->getParam('topicID');
			$this->view->activityCategory = $dbHelper->getTopicByID($topicID);	
		}
	}	
	/** Manage topic Ends **/
	
	/** Manage age groups Starts **/
	public function agegroupsAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		$this->view->activitycatList = $dbHelper->getAgeGroups();
		$this->view->selectedItem = 'itemActivities';
		$this->view->pageTitle = '<i class="fa fa-trophy"></i> Activities';
	}
	
	public function addagegroupsAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		$this->view->selectedItem = 'itemActivities';
		$this->view->pageTitle = '<i class="fa fa-trophy"></i> Activities';
		
		if($this->getRequest()->isPost()) {
			$catName = trim($this->getRequest()->getPost('txtAgeGroupsName'));
			$this->view->addResult = $dbHelper->addAgeGroups($catName);				
		}
	}
	
	public function deleteagegroupsAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();	
		
		$this->_helper->layout()->disableLayout();
	    $this->_helper->viewRenderer->setNoRender(true);
		
		$catID = $this->getRequest()->getParam('catID');
		echo $dbHelper->deleteActivityCategory($catID);
	}	
	
	public function editagegroupsAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		$this->view->selectedItem = 'itemActivities';
		$this->view->pageTitle = '<i class="fa fa-trophy"></i> Activities';
		
		if($this->getRequest()->isPost()) {
			$catName = trim($this->getRequest()->getPost('txtAgeGroup'));
			$catID = trim($this->getRequest()->getPost('hdnAgeGroupID'));
			$this->view->editResult = $dbHelper->updateAgeGroups($catName, $catID);				
		} else {
			$catID = $this->getRequest()->getParam('catID');
			$this->view->activityCategory = $dbHelper->getAgeGroupByID($catID);	
		}
	}	
	/** Manage age groups Ends **/	
}