<?php
class Admin_AdminsController extends Zend_Controller_Action {   
	public function init() {		
		session_start();
		$this->_helper->layout->setLayout('layout-admin');	
	}	
	public function checkActhentication() {
		if(!isset($_SESSION['s_authInfo'])) {
			$this->_redirect('/index');	
		}
	}
	
	/** Manage Admin Starts **/
	public function adminsAction() {
		$this->checkActhentication();
		$this->view->pageTitle = '<i class="fa fa-user"></i> Manage Administrators';
		$this->view->selectedItem = 'itemAdmins';
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		$this->view->adminList = $dbHelper->listAdmins();
	}
	
	public function addadminAction() {
		$this->checkActhentication();	
		if($this->getRequest()->isPost()) {
			$fname = trim($this->getRequest()->getPost('txtFName'));
			$lname = trim($this->getRequest()->getPost('txtLName'));
			$email = trim($this->getRequest()->getPost('txtEmail'));
			$uname = trim($this->getRequest()->getPost('txtUName'));
			$upass = trim($this->getRequest()->getPost('txtPass'));
			$status = $this->getRequest()->getPost('radStatus');
			$dbHelper = new Application_Model_Helpers_AdminHelper();
			$returnValue = $dbHelper->addAdmin($fname, $lname, $email, $uname, $upass, $status);
			$this->view->addResult = $returnValue;
		}
	}
	
	public function editadminAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		if($this->getRequest()->isPost()) {
			$admID = trim($this->getRequest()->getPost('hdnAdminID'));
			$fname = trim($this->getRequest()->getPost('txtFName'));
			$lname = trim($this->getRequest()->getPost('txtLName'));
			$email = trim($this->getRequest()->getPost('txtEmail'));
			$uname = trim($this->getRequest()->getPost('txtUName'));
			$upass = trim($this->getRequest()->getPost('txtPass'));
			$status = $this->getRequest()->getPost('radStatus');
			$dbHelper = new Application_Model_Helpers_AdminHelper();
			$returnValue = $dbHelper->updateAdmin($admID, $fname, $lname, $email, $uname, $upass, $status);
			$this->view->updateResult = $returnValue;
		} else {
			$admID = $this->getRequest()->getParam('admID');
			$this->view->admin = $dbHelper->getAdminDetail($admID);
		}
	}
	
	public function deleteadminAction() {
		$this->checkActhentication();
		
		$this->_helper->layout()->disableLayout();
	    $this->_helper->viewRenderer->setNoRender(true);
		
		$admID = $this->getRequest()->getParam('admID');
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		echo $dbHelper->deleteAdmin($admID);
	}
	/** Manage Admin Ends **/
	
}