<?php
class Admin_CmsController extends Zend_Controller_Action {   
	public function init() {		
		session_start();
		$this->_helper->layout->setLayout('layout-admin');	
	}	
	public function checkActhentication() {
		if(!isset($_SESSION['s_authInfo'])) {
			$this->_redirect('/admin/index');	
		}
	}
	
	/** Manage FAQ Starts **/
	public function faqAction() {
		$this->checkActhentication();
		
		$this->view->pageTitle = '<i class="fa fa-book"></i> Manage FAQs';
		$this->view->selectedItem = 'itemCMS';
		
		$dbHelper = new Application_Model_Helpers_CmsHelper();
		$this->view->faq = $dbHelper->fetchFAQs();
	}
	
	public function addfaqAction() {
		$this->checkActhentication();
		$this->view->pageTitle = '<i class="fa fa-book"></i> Manage FAQs';
		$this->view->selectedItem = 'itemCMS';
		
		if($this->getRequest()->isPost()) {
			$title = trim($this->getRequest()->getPost('txtTitle'));
			$details = trim($this->getRequest()->getPost('txtDetails'));	
			$status = trim($this->getRequest()->getPost('radStatus')); 
			
			$arrFAQ = array('title'=>$title, 'details'=>$details, 'adm_id'=>$_SESSION['s_authInfo']['adm_id'], 'status'=>$status);
			$dbHelper = new Application_Model_Helpers_CmsHelper();
			$this->view->addResult = $dbHelper->addFAQ($arrFAQ);
		}
	}
	
	public function deletefaqAction() {
		$this->checkActhentication();
		
		$this->_helper->layout()->disableLayout();
	    $this->_helper->viewRenderer->setNoRender(true);
		
		$faqID = $this->getRequest()->getParam('faqID');
		$dbHelper = new Application_Model_Helpers_CmsHelper();
		echo $dbHelper->deleteFAQ($faqID);
	}
	
	public function editfaqAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_CmsHelper();
		if($this->getRequest()->isPost()) {
			$arrFAQ = array('faqID'=>$this->getRequest()->getPost('hdnFAQID'),
							'title'=>trim($this->getRequest()->getPost('txtTitle')),
							'details'=>trim($this->getRequest()->getPost('txtDetails')),
							'status'=>$this->getRequest()->getPost('radStatus'));
			$this->view->updateResult = $dbHelper->updateFAQ($arrFAQ);
		} else {
			$faqID = $this->getRequest()->getParam('faqID');
			$this->view->faq = $dbHelper->getFAQDetail($faqID);	
		}
	}
	/** Manage FAQ Ends **/
	
	/** Manage Pages Starts **/
	public function pagesAction() {
		$this->checkActhentication();
		$this->view->pageTitle = '<i class="fa fa-file-text"></i> Manage Pages';
		$this->view->selectedItem = 'itemCMS';
		
		$dbHelper = new Application_Model_Helpers_CmsHelper();
		$this->view->pageList = $dbHelper->listPages();
	}
	
	public function deletepageAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_CmsHelper();
		
		$this->_helper->layout()->disableLayout();
	    $this->_helper->viewRenderer->setNoRender(true);
		
		$pageID = $this->getRequest()->getParam('pageID');
		$dbHelper = new Application_Model_Helpers_CmsHelper();
		echo $dbHelper->deletePage($pageID);
	}
	
	public function addpageAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_CmsHelper();
		
		$this->view->selectedItem = 'itemCMS';
		
		if($this->getRequest()->isPost()) {
			$title = trim($this->getRequest()->getPost('txtTitle'));
			$details = trim($this->getRequest()->getPost('txtDetails'));	
			$status = trim($this->getRequest()->getPost('radStatus')); 
			$metaTitle = trim($this->getRequest()->getPost('txtMetaTitle')); 
			$metaKeywords = trim($this->getRequest()->getPost('txtMetaKeywords')); 
			$metaDescription = trim($this->getRequest()->getPost('txtMetaDescription')); 
			
			$arrPage = array('title'=>$title, 'details'=>$details, 'adm_id'=>$_SESSION['s_authInfo']['adm_id'], 'status'=>$status, 'metaTitle'=>$metaTitle, 'metaKeywords'=>$metaKeywords, 'metaDescription'=>$metaDescription);
			
			$dbHelper = new Application_Model_Helpers_CmsHelper();
			$this->view->addResult = $dbHelper->addPage($arrPage);
		}
	}
	
	public function editpageAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_CmsHelper();
		if($this->getRequest()->isPost()) {
			$pageID = $this->getRequest()->getPost('hdnPageID');
			$title = trim($this->getRequest()->getPost('txtTitle'));
			$details = trim($this->getRequest()->getPost('txtDetails'));	
			$status = trim($this->getRequest()->getPost('radStatus')); 
			$metaTitle = trim($this->getRequest()->getPost('txtMetaTitle')); 
			$metaKeywords = trim($this->getRequest()->getPost('txtMetaKeywords')); 
			$metaDescription = trim($this->getRequest()->getPost('txtMetaDescription')); 
			
			$arrPage = array('pageID'=>$pageID, 'title'=>$title, 'details'=>$details, 'adm_id'=>$_SESSION['s_authInfo']['adm_id'], 'status'=>$status, 'metaTitle'=>$metaTitle, 'metaKeywords'=>$metaKeywords, 'metaDescription'=>$metaDescription);
			$this->view->updateResult = $dbHelper->updatePage($arrPage);
		} else {
			$pgID = $this->getRequest()->getParam('pgID');
			$this->view->pg = $dbHelper->getPageDetails($pgID);	
		}
	}
	/** Manage Pages Ends **/
	
}