<?php
class Admin_IndexController extends Zend_Controller_Action {   
	public function init() {		
		session_start();
		$this->_helper->layout->setLayout('layout-admin');	
	}	
	public function checkActhentication() {
		if(!isset($_SESSION['s_authInfo'])) {
			$this->_redirect('/index');	
		}
	}
	
	public function indexAction() {
		$this->_helper->layout->setLayout('layout-admin-login');
	}
	
	public function loginAction() {
		$this->_helper->layout()->disableLayout();
	    $this->_helper->viewRenderer->setNoRender(true);
		
		$u = trim($this->getRequest()->getParam('u'));
		$p = trim($this->getRequest()->getParam('p'));
		
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		if($dbHelper->authenticate($u, $p)) { //Login
			$_SESSION['s_authInfo'] = $dbHelper->getAdminInfo($u, $p);
			$dbHelper->updateLoginDateTime($_SESSION['s_authInfo']['adm_id']);
			echo 1;
		} else {
			echo -1;
		}
	}
	
	public function logoutAction() {
		$this->checkActhentication();
		unset($_SESSION['s_authInfo']);
		$this->_redirect('/admin/index');
	}
	
	public function dashboardAction() {
		$this->checkActhentication();
		$this->view->pageTitle = '<i class="fa fa-dashboard"></i> Dashboard';
		$this->view->selectedItem = 'itemDashboard';
	}
	
}