<?php
class Admin_QuestionsController extends Zend_Controller_Action {   
	public function init() {		
		session_start();
		$this->_helper->layout->setLayout('layout-admin');	
	}	
	public function checkActhentication() {
		if(!isset($_SESSION['s_authInfo'])) {
			$this->_redirect('/admin/index');	
		}
	}
	
	public function indexAction() {
		$this->checkActhentication();
		$this->_helper->layout()->disableLayout();
	    $this->_helper->viewRenderer->setNoRender(true);
		$db = new Application_Model_Helpers_QuestionHelper();
		
		$activityID = $this->getRequest()->getParam('activityID');
		$redirectAction = $db->getQuestionAction($activityID);
		$this->_redirect('/admin/questions/'.$redirectAction);
	}
	/** Matching **/
	public function matchingquestionsAction() {
		$this->checkActhentication();
		
		$this->view->selectedItem = 'itemActivities';
		$this->view->pageTitle = '<i class="fa fa-trophy"></i> Activities';
		
		$activityID = $this->getRequest()->getParam('activityID');
		
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		$this->view->act = $dbHelper->getActivityByID($activityID);	
		
		$db = new Application_Model_Helpers_QuestionHelper();
		$this->view->ques = $db->matchingQuestions($activityID);
	}
	
	public function managematchingAction() {
		$this->checkActhentication();
		
		$this->view->selectedItem = 'itemActivities';
		$this->view->pageTitle = '<i class="fa fa-trophy"></i> Activities';
		
		$db = new Application_Model_Helpers_QuestionHelper();
		if($this->getRequest()->isPost()) {
			$arr = array();
			$arr['quesID'] = $this->getRequest()->getPost('hdnQuesID');
			$arr['actID'] = $this->getRequest()->getPost('hdnActID');
			$arr['col1'] = $this->getRequest()->getPost('txtCol1');
			$arr['col2'] = $this->getRequest()->getPost('txtCol2');
			$arr['stat'] = $this->getRequest()->getPost('selQuesStatus');
			$this->view->addResult = $db->saveMatchingQuestion($arr);
			$this->view->actID = $arr['actID'];
		} else {
			$activityID = $this->getRequest()->getParam('activityID');
			
			$dbHelper = new Application_Model_Helpers_AdminHelper();
			$this->view->act = $dbHelper->getActivityByID($activityID);			
			$this->view->actID = $activityID;
			if($this->getRequest()->getParam('quesID')) { //Edit
				$this->view->ques = $db->getQuestionByID($this->getRequest()->getParam('quesID'));
			}
		}
	}
	/** Matching **/
	
	/** Choices **/
	public function choicesquestionsAction() {
		$this->checkActhentication();
		
		$this->view->selectedItem = 'itemActivities';
		$this->view->pageTitle = '<i class="fa fa-trophy"></i> Activities';
		
		$activityID = $this->getRequest()->getParam('activityID');
		
		$dbHelper = new Application_Model_Helpers_AdminHelper();		
		$this->view->act = $dbHelper->getActivityByID($activityID);	
		
		$db = new Application_Model_Helpers_QuestionHelper();
		$this->view->ques = $db->choicesQuestions($activityID);
	}
	
	public function managechoicesAction() {
		$this->checkActhentication();
		
		$this->view->selectedItem = 'itemActivities';
		$this->view->pageTitle = '<i class="fa fa-trophy"></i> Activities';
		
		$db = new Application_Model_Helpers_QuestionHelper();
		if($this->getRequest()->isPost()) {
			$arr = array();
			$arr['quesID'] = $this->getRequest()->getPost('hdnQuesID');
			$arr['actID'] = $this->getRequest()->getPost('hdnActID');
			$arr['quesText'] = $this->getRequest()->getPost('txtQuestion');
			$arr['correctFeedback'] = $this->getRequest()->getPost('txtCorrect');
			$arr['incorrectFeedback'] = $this->getRequest()->getPost('txtIncorrect');
			$arr['stat'] = $this->getRequest()->getPost('selQuesStatus');
			for($i=0; $i<5; $i++) {
				$ans = addslashes(trim($this->getRequest()->getPost('txtAns'.$i)));
				if($ans!='') {
					$arr['answers'][$i]['ansID'] = $this->getRequest()->getPost('hdnAnsID'.$i);
					$arr['answers'][$i]['ans'] = $ans;
					$arr['answers'][$i]['feedback'] = addslashes(trim($this->getRequest()->getPost('txtFB'.$i)));
					if($this->getRequest()->getPost('chk'.$i)) {
						$arr['correctAns'] = $this->getRequest()->getPost('chk'.$i);	
					}
				}
			}
			$this->view->addResult = $db->saveChoicesQuestion($arr);
			$this->view->actID = $arr['actID'];
		} else {
			$activityID = $this->getRequest()->getParam('activityID');
			
			$dbHelper = new Application_Model_Helpers_AdminHelper();
			$this->view->act = $dbHelper->getActivityByID($activityID);			
			$this->view->actID = $activityID;
			if($this->getRequest()->getParam('quesID')) { //Edit
				$this->view->ques = $db->getChoicesQuestionByID($this->getRequest()->getParam('quesID'));
			}
		}
	}
	/** Choices **/
	
	/** Forming **/
	public function formingquestionsAction() {
		$this->checkActhentication();
		
		$this->view->selectedItem = 'itemActivities';
		$this->view->pageTitle = '<i class="fa fa-trophy"></i> Activities';
		
		$activityID = $this->getRequest()->getParam('activityID');
		
		$dbHelper = new Application_Model_Helpers_AdminHelper();		
		$this->view->act = $dbHelper->getActivityByID($activityID);	
		
		$db = new Application_Model_Helpers_QuestionHelper();
		$this->view->ques = $db->formingQuestions($activityID);
	}
	
	public function manageformingAction() {
		$this->checkActhentication();
		
		$this->view->selectedItem = 'itemActivities';
		$this->view->pageTitle = '<i class="fa fa-trophy"></i> Activities';
		
		$db = new Application_Model_Helpers_QuestionHelper();
		if($this->getRequest()->isPost()) {
			$arr = array();
			$arr['quesID'] = $this->getRequest()->getPost('hdnQuesID');
			$arr['actID'] = $this->getRequest()->getPost('hdnActID');
			$arr['col1'] = $this->getRequest()->getPost('txtCol1');
			$arr['col2'] = $this->getRequest()->getPost('txtCol2');
			$arr['stat'] = $this->getRequest()->getPost('selQuesStatus');
			$this->view->addResult = $db->saveFormingQuestion($arr);
			$this->view->actID = $arr['actID'];
		} else {
			$activityID = $this->getRequest()->getParam('activityID');
			
			$dbHelper = new Application_Model_Helpers_AdminHelper();
			$this->view->act = $dbHelper->getActivityByID($activityID);			
			
			if($this->getRequest()->getParam('quesID')) { //Edit
				$this->view->ques = $db->getFormingQuestionByID($this->getRequest()->getParam('quesID'));
			}
		}
	}
	/** Forming **/
}