<?php
class Admin_VideosController extends Zend_Controller_Action {   
	public function init() {		
		session_start();
		$this->_helper->layout->setLayout('layout-admin');	
	}	
	public function checkActhentication() {
		if(!isset($_SESSION['s_authInfo'])) {
			$this->_redirect('/admin/index');	
		}
	}
		
	/** Manage Video Starts **/
	public function videoAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		$this->view->activitycatList = $dbHelper->getVideo();
		$this->view->selectedItem = 'itemVideo';
		$this->view->pageTitle = '<i class="fa fa-video-camera"></i> Videos';
	}
	
	public function addvideoAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		$this->view->ageGroups = $dbHelper->getAgeGroups();
		$this->view->selectedItem = 'itemVideo';
		$this->view->pageTitle = '<i class="fa fa-video-camera"></i> Videos';
		if($this->getRequest()->isPost()) {
			$target = ABSOLUTE_URL."/assets/video/";
			$tm = time().@$_FILES['txtThumbnail']['name'];
			$target = $target . basename( $tm);
			$Filename=basename( $tm);
			
			@move_uploaded_file(@$_FILES['txtThumbnail']['tmp_name'], $target);
			//exit;
			
			$age_group = trim(addslashes($this->getRequest()->getPost('txtAgeGroup')));
			$video_title = trim(addslashes($this->getRequest()->getPost('txtVideoTitle')));
			//$video_thumbnail = trim($this->getRequest()->getPost('txtThumbnail'));
			$video_thumbnail = $Filename;
			$video_embed_code = trim(addslashes($this->getRequest()->getPost('txtEmbedCode')));
			$video_description = trim(addslashes($this->getRequest()->getPost('txtDescription')));
			$this->view->addResult = $dbHelper->addVideo($age_group, $video_title, $video_thumbnail, $video_embed_code, $video_description);	
			
		}
	}
	
	public function deletevideoAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();	
		
		$this->_helper->layout()->disableLayout();
	    $this->_helper->viewRenderer->setNoRender(true);
		
		$catID = $this->getRequest()->getParam('catID');
		echo $dbHelper->deleteActivityCategory($catID);
	}	
	
	public function editvideoAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		$this->view->ageGroups = $dbHelper->getAgeGroups();
		
		$videoID = $this->getRequest()->getParam('videoID');
		$this->view->activityCategory = $rec = $dbHelper->getVideoByID($videoID);	
		
		if($this->getRequest()->isPost()) {
			$Filename= $rec['video_thumbnail'];
			if(@$_FILES['txtThumbnail']['name']){
				$target = ABSOLUTE_URL."/assets/video/";
				$tm = time().@$_FILES['txtThumbnail']['name'];
				$target = $target . basename( $tm);
				$Filename=basename( $tm);
				
				@move_uploaded_file(@$_FILES['txtThumbnail']['tmp_name'], $target);
			}
			
			
			$age_group = trim(addslashes($this->getRequest()->getPost('txtAgeGroup')));
			$video_title = trim(addslashes($this->getRequest()->getPost('txtVideoTitle')));
			//$video_thumbnail = trim($this->getRequest()->getPost('txtThumbnail'));
			$video_thumbnail = $Filename;
			$video_embed_code = trim(addslashes($this->getRequest()->getPost('txtEmbedCode')));
			$video_description = trim(addslashes($this->getRequest()->getPost('txtDescription')));
			$catID = trim($this->getRequest()->getPost('hdnID'));
			$this->view->editResult = $dbHelper->updateVideo($age_group,$video_title,$video_thumbnail,$video_embed_code,$video_description, $catID);	
			
		} else {
			
		}
		$this->view->selectedItem = 'itemVideo';
		$this->view->pageTitle = '<i class="fa fa-video-camera"></i> Videos';
	}
	
	
	public function playvideoAction() {
		$this->checkActhentication();
		$this->_helper->layout()->disableLayout();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		$this->view->ageGroups = $dbHelper->getAgeGroups();
		
		$videoID = $this->getRequest()->getParam('id');
		$this->view->activityCategory = $rec = $dbHelper->getVideoByID($videoID);	
		
			}
	
	/** Manage Video Ends **/
	
}