<?php
class Admin_XmlController extends Zend_Controller_Action {   
	public function init() {		
		session_start();
		$this->_helper->layout()->disableLayout();
	    $this->_helper->viewRenderer->setNoRender(true);
	}	
		
	public function appendCdata($appendToNode, $text) {
		if (strtolower($appendToNode->nodeName) == 'script') {  // Javascript hack
			$cm = $appendToNode->ownerDocument->createTextNode("\n//");
			$ct = $appendToNode->ownerDocument->createCDATASection("\n" . $text . "\n//");
			$appendToNode->appendChild($cm);
			$appendToNode->appendChild($ct);
		} else {  // Normal CDATA node
			$ct = $appendToNode->ownerDocument->createCDATASection($text);
			$appendToNode->appendChild($ct);
		}
	}

	/** Matching **/
	public function matchingxmlAction() {
		$db = new Application_Model_Helpers_XmlHelper();
		$activityID = $this->getRequest()->getParam('activityID');
		
		$data = $db->getMatchingActivityData($activityID);
		
		header('Content-Type: text/xml');
		$xml = new DOMDocument();
		$act = $xml->createElement('activity');
		$xml->appendChild($act);
		$act->setAttribute('oae-label', 'Matching');
		
		$title = new DOMElement('title');
		$act->appendChild($title);
		$title->setAttribute('oae-label', 'Title');
		$this->appendCdata($title, $data['match']['match_title']);
		
		$short = new DOMElement('shortinst');
		$act->appendChild($short);
		$short->setAttribute('oae-label', 'Short Instruction');
		$this->appendCdata($short, $data['match']['match_short_desc']);
		
		$long = new DOMElement('detailinst');
		$act->appendChild($long);
		$long->setAttribute('oae-label', 'Detailed Instructions');
		$this->appendCdata($long, $data['match']['match_long_desc']);
		
		$rand = new DOMElement('randomanswers');
		$act->appendChild($rand);
		$rand->setAttribute('oae-label', 'Randomize Answers');
		if($data['match']['match_rand_ans']==1)
			$rand->setAttribute('value', 'yes');
		else
			$rand->setAttribute('value', 'no');
		
		$q = new DOMElement('question');
		$act->appendChild($q);
		$q->setAttribute('oae-label', 'Question');
		
		for($i=0, $j=1; $i<count($data['ques']); $i++, $j++) {
			$term = new DOMElement('term');
			$q->appendChild($term);
			$term->setAttribute('oae-label', 'Term '.$j);
			
			$ques = new DOMElement('termtext');
			$term->appendChild($ques);
			$ques->setAttribute('oae-label', 'Term Text');
			$this->appendCdata($ques, $data['ques'][$i]['match_ques_term_text']);
			
			$ans = new DOMElement('answer');
			$term->appendChild($ans);
			$ans->setAttribute('oae-label', 'Answer '.$j);
			$this->appendCdata($ans, $data['ques'][$i]['match_ques_answer']);
		}
		echo $xml->saveXML();
		
	}
	/** Matching **/
	
	/** Choices **/
	public function choicesxmlAction() {
		$db = new Application_Model_Helpers_XmlHelper();
		$activityID = $this->getRequest()->getParam('activityID');
		
		$data = $db->getMCQActivityData($activityID);
		
		header('Content-Type: text/xml');
		$xml = new DOMDocument();
		$act = $xml->createElement('activity');
		$xml->appendChild($act);
		$act->setAttribute('oae-label', 'Multiple Choices');
		
		$title = new DOMElement('title');
		$act->appendChild($title);
		$title->setAttribute('oae-label', 'Title');
		$this->appendCdata($title, $data['choices']['choices_title']);
		
		$short = new DOMElement('shortinst');
		$act->appendChild($short);
		$short->setAttribute('oae-label', 'Short Instruction');
		$this->appendCdata($short, $data['choices']['choices_short_desc']);
		
		$long = new DOMElement('detailinst');
		$act->appendChild($long);
		$long->setAttribute('oae-label', 'Detailed Instructions');
		$this->appendCdata($long, $data['choices']['choices_long_desc']);
		
		$rand = new DOMElement('randomanswers');
		$act->appendChild($rand);
		$rand->setAttribute('oae-label', 'Randomize Answers');
		if($data['choices']['choices_rand_ans']==1)
			$rand->setAttribute('value', 'yes');
		else
			$rand->setAttribute('value', 'no');
		
		$q = new DOMElement('questions');
		$act->appendChild($q);
		$q->setAttribute('oae-label', 'Questions');
		
		for($i=0; $i<count($data['questions']); $i++) {
			$qNum = $i+1;
			$ques = new DOMElement('question');
			$q->appendChild($ques);
			$ques->setAttribute('oae-label', 'Question '.$qNum);
			
			$qt = new DOMElement('questiontext');
			$ques->appendChild($qt);
			$qt->setAttribute('oae-label', 'Question Text');
			$this->appendCdata($qt, $data['questions'][$i]['question']);
			
			for($j=0; $j<count($data['questions'][$i]['answers']); $j++) {
				$ansNum = $j+1;
				$a = new DOMElement('answer');
				$ques->appendChild($a);
				$a->setAttribute('oae-label', 'Answer '.$ansNum);
				$this->appendCdata($a, $data['questions'][$i]['answers'][$j]['ans']);
				
				$f = new DOMElement('feedback');
				$ques->appendChild($f);
				$f->setAttribute('oae-label', 'Specific feedback for Answer '.$ansNum);
				$this->appendCdata($f, $data['questions'][$i]['answers'][$j]['feedback']);
			}
			for($k=$j; $k<6; $k++) {
				$ansNum = $k+1;
				$a = new DOMElement('answer');
				$ques->appendChild($a);
				$a->setAttribute('oae-label', 'Answer '.$ansNum);
				$this->appendCdata($a, '');
				
				$f = new DOMElement('feedback');
				$ques->appendChild($f);
				$f->setAttribute('oae-label', 'Specific feedback for Answer '.$ansNum);
				$this->appendCdata($f, '');
			}
			$ca = new DOMElement('correctanswer');
			$ques->appendChild($ca);
			$ca->setAttribute('oae-label', 'Correct Answer Number');
			$this->appendCdata($ca, $data['questions'][$i]['correct']);
		}
			
		echo $xml->saveXML();
	}
	/** Choices **/
	
	/** Forming **/
	public function formingxmlAction() {
		$db = new Application_Model_Helpers_XmlHelper();
		$activityID = $this->getRequest()->getParam('activityID');
		
		$data = $db->getFormingActivityData($activityID);
		
		header('Content-Type: text/xml');
		$xml = new DOMDocument();
		$act = $xml->createElement('activity');
		$xml->appendChild($act);
		$act->setAttribute('oae-label', 'Forming Terms');
		
		$title = new DOMElement('title');
		$act->appendChild($title);
		$title->setAttribute('oae-label', 'Title');
		$this->appendCdata($title, $data['forming']['forming_title']);
		
		$short = new DOMElement('shortinst');
		$act->appendChild($short);
		$short->setAttribute('oae-label', 'Short Instruction');
		$this->appendCdata($short, $data['forming']['forming_short_desc']);
		
		$long = new DOMElement('detailinst');
		$act->appendChild($long);
		$long->setAttribute('oae-label', 'Detailed Instructions');
		$this->appendCdata($long, $data['forming']['forming_long_desc']);
		
		$rand = new DOMElement('randomize');
		$act->appendChild($rand);
		$rand->setAttribute('oae-label', 'Randomize Answers');
		if($data['forming']['forming_rand_ques']==1)
			$rand->setAttribute('value', 'yes');
		else
			$rand->setAttribute('value', 'no');
		
		$head = new DOMElement('headings');
		$act->appendChild($head);
		
		$h = new DOMElement('heading');
		$head->appendChild($h);
		$h->setAttribute('id', '1');
		$this->appendCdata($h, $data['forming']['forming_heading_1']);
		
		$h = new DOMElement('heading');
		$head->appendChild($h);
		$h->setAttribute('id', '2');
		$this->appendCdata($h, $data['forming']['forming_heading_2']);
		
		$t = new DOMElement('terms');
		$act->appendChild($t);
		
		$idx = 1;
		for($i=0; $i<count($data['terms']); $i++) {
			$term = new DOMElement('term');
			$t->appendChild($term);
			$term->setAttribute('id', $idx);
			
			$abbr = new DOMElement('abbr');
			$term->appendChild($abbr);
			$this->appendCdata($abbr, $data['terms'][$i]['term']);
			
			$ans = new DOMElement('answer');
			$term->appendChild($ans);
			$this->appendCdata($ans, $data['terms'][$i]['answer']);
			
			$idx++;	
		}
		echo $xml->saveXML();
	}
	/** Forming **/
}