<?php
class AdminController extends Zend_Controller_Action {
    public function init() {		
		$ns = new Zend_Session_Namespace('PublicSite');
		$this->_helper->layout->setLayout('layout-admin');
    }	
	
	public function checkActhentication() {
		if(!isset($_SESSION['s_authInfo'])) {
			$this->_redirect('/index');	
		}
	}
	
	public function indexAction() {
		$this->_helper->layout->setLayout('layout-admin-login');
	}
	
	public function loginAction() {
		$this->_helper->layout()->disableLayout();
	    $this->_helper->viewRenderer->setNoRender(true);
		
		$u = trim($this->getRequest()->getParam('u'));
		$p = trim($this->getRequest()->getParam('p'));
		
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		if($dbHelper->authenticate($u, $p)) { //Login
			$_SESSION['s_authInfo'] = $dbHelper->getAdminInfo($u, $p);
			$dbHelper->updateLoginDateTime($_SESSION['s_authInfo']['adm_id']);
			echo 1;
		} else {
			echo -1;
		}
	}
	
	public function logoutAction() {
		$this->checkActhentication();
		unset($_SESSION['s_authInfo']);
		$this->_redirect('/admin/index');
	}
	
	public function dashboardAction() {
		$this->checkActhentication();
		$this->view->pageTitle = '<i class="fa fa-dashboard"></i> Dashboard';
		$this->view->selectedItem = 'itemDashboard';
	}
	
	/** Manage Admin Starts **/
	public function adminsAction() {
		$this->checkActhentication();
		$this->view->pageTitle = '<i class="fa fa-user"></i> Manage Administrators';
		$this->view->selectedItem = 'itemAdmins';
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		$this->view->adminList = $dbHelper->listAdmins();
	}
	
	public function addadminAction() {
		$this->checkActhentication();	
		if($this->getRequest()->isPost()) {
			$fname = trim($this->getRequest()->getPost('txtFName'));
			$lname = trim($this->getRequest()->getPost('txtLName'));
			$email = trim($this->getRequest()->getPost('txtEmail'));
			$uname = trim($this->getRequest()->getPost('txtUName'));
			$upass = trim($this->getRequest()->getPost('txtPass'));
			$status = $this->getRequest()->getPost('radStatus');
			$dbHelper = new Application_Model_Helpers_AdminHelper();
			$returnValue = $dbHelper->addAdmin($fname, $lname, $email, $uname, $upass, $status);
			$this->view->addResult = $returnValue;
		}
	}
	
	public function editadminAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		if($this->getRequest()->isPost()) {
			$admID = trim($this->getRequest()->getPost('hdnAdminID'));
			$fname = trim($this->getRequest()->getPost('txtFName'));
			$lname = trim($this->getRequest()->getPost('txtLName'));
			$email = trim($this->getRequest()->getPost('txtEmail'));
			$uname = trim($this->getRequest()->getPost('txtUName'));
			$upass = trim($this->getRequest()->getPost('txtPass'));
			$status = $this->getRequest()->getPost('radStatus');
			$dbHelper = new Application_Model_Helpers_AdminHelper();
			$returnValue = $dbHelper->updateAdmin($admID, $fname, $lname, $email, $uname, $upass, $status);
			$this->view->updateResult = $returnValue;
		} else {
			$admID = $this->getRequest()->getParam('admID');
			$this->view->admin = $dbHelper->getAdminDetail($admID);
		}
	}
	
	public function deleteadminAction() {
		$this->checkActhentication();
		
		$this->_helper->layout()->disableLayout();
	    $this->_helper->viewRenderer->setNoRender(true);
		
		$admID = $this->getRequest()->getParam('admID');
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		echo $dbHelper->deleteAdmin($admID);
	}
	/** Manage Admin Ends **/
	
	/** Manage FAQ Starts **/
	public function faqAction() {
		$this->checkActhentication();
		
		$this->view->pageTitle = '<i class="fa fa-book"></i> Manage FAQs';
		$this->view->selectedItem = 'itemCMS';
		
		$dbHelper = new Application_Model_Helpers_CmsHelper();
		$this->view->faq = $dbHelper->fetchFAQs();
	}
	
	public function addfaqAction() {
		$this->checkActhentication();
		$this->view->pageTitle = '<i class="fa fa-book"></i> Manage FAQs';
		$this->view->selectedItem = 'itemCMS';
		
		if($this->getRequest()->isPost()) {
			$title = trim($this->getRequest()->getPost('txtTitle'));
			$details = trim($this->getRequest()->getPost('txtDetails'));	
			$status = trim($this->getRequest()->getPost('radStatus')); 
			
			$arrFAQ = array('title'=>$title, 'details'=>$details, 'adm_id'=>$_SESSION['s_authInfo']['adm_id'], 'status'=>$status);
			$dbHelper = new Application_Model_Helpers_CmsHelper();
			$this->view->addResult = $dbHelper->addFAQ($arrFAQ);
		}
	}
	
	public function deletefaqAction() {
		$this->checkActhentication();
		
		$this->_helper->layout()->disableLayout();
	    $this->_helper->viewRenderer->setNoRender(true);
		
		$faqID = $this->getRequest()->getParam('faqID');
		$dbHelper = new Application_Model_Helpers_CmsHelper();
		echo $dbHelper->deleteFAQ($faqID);
	}
	
	public function editfaqAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_CmsHelper();
		if($this->getRequest()->isPost()) {
			$arrFAQ = array('faqID'=>$this->getRequest()->getPost('hdnFAQID'),
							'title'=>trim($this->getRequest()->getPost('txtTitle')),
							'details'=>trim($this->getRequest()->getPost('txtDetails')),
							'status'=>$this->getRequest()->getPost('radStatus'));
			$this->view->updateResult = $dbHelper->updateFAQ($arrFAQ);
		} else {
			$faqID = $this->getRequest()->getParam('faqID');
			$this->view->faq = $dbHelper->getFAQDetail($faqID);	
		}
	}
	/** Manage FAQ Ends **/
	
	/** Manage Pages Starts **/
	public function pagesAction() {
		$this->checkActhentication();
		$this->view->pageTitle = '<i class="fa fa-file-text"></i> Manage Pages';
		$this->view->selectedItem = 'itemCMS';
		
		$dbHelper = new Application_Model_Helpers_CmsHelper();
		$this->view->pageList = $dbHelper->listPages();
	}
	
	public function deletepageAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_CmsHelper();
		
		$this->_helper->layout()->disableLayout();
	    $this->_helper->viewRenderer->setNoRender(true);
		
		$pageID = $this->getRequest()->getParam('pageID');
		$dbHelper = new Application_Model_Helpers_CmsHelper();
		echo $dbHelper->deletePage($pageID);
	}
	
	public function addpageAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_CmsHelper();
		
		$this->view->selectedItem = 'itemCMS';
		
		if($this->getRequest()->isPost()) {
			$title = trim($this->getRequest()->getPost('txtTitle'));
			$details = trim($this->getRequest()->getPost('txtDetails'));	
			$status = trim($this->getRequest()->getPost('radStatus')); 
			$metaTitle = trim($this->getRequest()->getPost('txtMetaTitle')); 
			$metaKeywords = trim($this->getRequest()->getPost('txtMetaKeywords')); 
			$metaDescription = trim($this->getRequest()->getPost('txtMetaDescription')); 
			
			$arrPage = array('title'=>$title, 'details'=>$details, 'adm_id'=>$_SESSION['s_authInfo']['adm_id'], 'status'=>$status, 'metaTitle'=>$metaTitle, 'metaKeywords'=>$metaKeywords, 'metaDescription'=>$metaDescription);
			
			$dbHelper = new Application_Model_Helpers_CmsHelper();
			$this->view->addResult = $dbHelper->addPage($arrPage);
		}
	}
	
	public function editpageAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_CmsHelper();
		if($this->getRequest()->isPost()) {
			$pageID = $this->getRequest()->getPost('hdnPageID');
			$title = trim($this->getRequest()->getPost('txtTitle'));
			$details = trim($this->getRequest()->getPost('txtDetails'));	
			$status = trim($this->getRequest()->getPost('radStatus')); 
			$metaTitle = trim($this->getRequest()->getPost('txtMetaTitle')); 
			$metaKeywords = trim($this->getRequest()->getPost('txtMetaKeywords')); 
			$metaDescription = trim($this->getRequest()->getPost('txtMetaDescription')); 
			
			$arrPage = array('pageID'=>$pageID, 'title'=>$title, 'details'=>$details, 'adm_id'=>$_SESSION['s_authInfo']['adm_id'], 'status'=>$status, 'metaTitle'=>$metaTitle, 'metaKeywords'=>$metaKeywords, 'metaDescription'=>$metaDescription);
			$this->view->updateResult = $dbHelper->updatePage($arrPage);
		} else {
			$pgID = $this->getRequest()->getParam('pgID');
			$this->view->pg = $dbHelper->getPageDetails($pgID);	
		}
	}
	/** Manage Pages Ends **/
	
	/** Manage Activity Category Starts **/
	public function activitycategoriesAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		$this->view->activitycatList = $dbHelper->getActivityCategories();
		$this->view->selectedItem = 'itemSettings';
	}
	

	
	public function addactivitycategoryAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		
		if($this->getRequest()->isPost()) {
			$catName = trim($this->getRequest()->getPost('txtCatName'));
			$this->view->addResult = $dbHelper->addActivityCategory($catName);	
			$this->view->selectedItem = 'itemSettings';
		}
	}
	
	public function deleteactivitycategoryAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();	
		
		$this->_helper->layout()->disableLayout();
	    $this->_helper->viewRenderer->setNoRender(true);
		
		$catID = $this->getRequest()->getParam('catID');
		echo $dbHelper->deleteActivityCategory($catID);
	}	
	
	public function editactivitycategoryAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		
		if($this->getRequest()->isPost()) {
			$catName = trim($this->getRequest()->getPost('txtCatName'));
			$catID = trim($this->getRequest()->getPost('hdnCatID'));
			$this->view->editResult = $dbHelper->updateActivityCategory($catName, $catID);	
			$this->view->selectedItem = 'itemSettings';
		} else {
			$catID = $this->getRequest()->getParam('catID');
			$this->view->activityCategory = $dbHelper->getActivityCategory($catID);	
		}
	}
	/** Manage Activity Category Ends **/
	
	/** Manage activities Starts **/
	public function activitiesAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		$this->view->activitycatList = $dbHelper->getActivities();
		$this->view->selectedItem = 'itemActivities';
	}
	
	public function addactivitiesAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		
		$this->view->activityCategoryRec = $dbHelper->getActivityCategories();
		$this->view->ageGroups = $dbHelper->getAgeGroups();
		
		if($this->getRequest()->isPost()) {
			$catID = trim($this->getRequest()->getPost('catID'));
			$agegroupID = trim($this->getRequest()->getPost('agegroupID'));
			$actTitle = trim($this->getRequest()->getPost('actTitle'));
			$actShortdesc = trim($this->getRequest()->getPost('actShortdesc'));
			$actLongdesc = trim($this->getRequest()->getPost('actLongdesc'));
			$actstatus = trim($this->getRequest()->getPost('actstatus'));
			
			
			$this->view->addResult = $dbHelper->addActivities($catID,$agegroupID,$actTitle,$actShortdesc,$actLongdesc,$actstatus);	
			
			$this->view->selectedItem = 'itemActivities';
		}
	}
	
	public function deleteactivitiesAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();	
		
		$this->_helper->layout()->disableLayout();
	    $this->_helper->viewRenderer->setNoRender(true);
		
		$catID = $this->getRequest()->getParam('catID');
		echo $dbHelper->deleteActivityCategory($catID);
	}	
	
	public function editactivitiesAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		
		if($this->getRequest()->isPost()) {
			$catID = trim($this->getRequest()->getPost('catID'));
			$agegroupID = trim($this->getRequest()->getPost('agegroupID'));
			$actTitle = trim($this->getRequest()->getPost('actTitle'));
			$actShortdesc = trim($this->getRequest()->getPost('actShortdesc'));
			$actLongdesc = trim($this->getRequest()->getPost('actLongdesc'));
			$actstatus = trim($this->getRequest()->getPost('actstatus'));
			
			$actID = trim($this->getRequest()->getPost('hdnID'));
			$this->view->editResult = $dbHelper->updateActivities($catID,$agegroupID,$actTitle,$actShortdesc,$actLongdesc,$actstatus, $actID);	
			$this->view->selectedItem = 'itemActivities';
		} else {
			$catID = $this->getRequest()->getParam('activityID');
			$this->view->activityCategory = $dbHelper->getActivityByID($catID);	
			$this->view->activityCategoryRec = $dbHelper->getActivityCategories();
			$this->view->ageGroups = $dbHelper->getAgeGroups();
			
				
		}
	}
	
	/** Manage activities Ends **/
		
	/** Manage Topic Starts **/
	public function topicAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		$this->view->activitycatList = $dbHelper->getTopic();
		$this->view->selectedItem = 'itemTopic';
	}
	
	public function addtopicAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		
		if($this->getRequest()->isPost()) {
			$txtTopic = trim($this->getRequest()->getPost('txtTopic'));
			$this->view->addResult = $dbHelper->addTopic($txtTopic);	
			$this->view->selectedItem = 'itemTopic';
		}
	}
	
	public function deletetopicAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();	
		
		$this->_helper->layout()->disableLayout();
	    $this->_helper->viewRenderer->setNoRender(true);
		
		$catID = $this->getRequest()->getParam('catID');
		echo $dbHelper->deleteActivityCategory($catID);
	}	
	
	public function edittopicAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		
		if($this->getRequest()->isPost()) {
			$catName = trim($this->getRequest()->getPost('txtTopicName'));
			$catID = trim($this->getRequest()->getPost('hdnID'));
			$this->view->editResult = $dbHelper->updateTopic($catName, $catID);	
			$this->view->selectedItem = 'itemTopic';
		} else {
			$topicID = $this->getRequest()->getParam('topicID');
			$this->view->activityCategory = $dbHelper->getTopicByID($topicID);	
		}
	}
	
	/** Manage topic Ends **/
	
	/** Manage age groups Starts **/
	public function agegroupsAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		$this->view->activitycatList = $dbHelper->getAgeGroups();
		$this->view->selectedItem = 'itemAgeGroups';
	}
	
	public function addagegroupsAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		
		if($this->getRequest()->isPost()) {
			$catName = trim($this->getRequest()->getPost('txtAgeGroupsName'));
			$this->view->addResult = $dbHelper->addAgeGroups($catName);	
			$this->view->selectedItem = 'itemAgeGroups';
		}
	}
	
	public function deleteagegroupsAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();	
		
		$this->_helper->layout()->disableLayout();
	    $this->_helper->viewRenderer->setNoRender(true);
		
		$catID = $this->getRequest()->getParam('catID');
		echo $dbHelper->deleteActivityCategory($catID);
	}	
	
	public function editagegroupsAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		
		if($this->getRequest()->isPost()) {
			$catName = trim($this->getRequest()->getPost('txtCatName'));
			$catID = trim($this->getRequest()->getPost('hdnCatID'));
			$this->view->editResult = $dbHelper->updateActivityCategory($catName, $catID);	
			$this->view->selectedItem = 'itemAgeGroups';
		} else {
			$catID = $this->getRequest()->getParam('catID');
			$this->view->activityCategory = $dbHelper->getActivityCategory($catID);	
		}
	}
	
	
	/** Manage age groups Ends **/
	
	/** Manage Topic Starts **/
	public function videoAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		$this->view->activitycatList = $dbHelper->getVideo();
		$this->view->selectedItem = 'itemVideo';
	}
	
	public function addvideoAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		$this->view->ageGroups = $dbHelper->getAgeGroups();
		
		if($this->getRequest()->isPost()) {
			$target = ABSOLUTE_URL."/assets/video/";
			$tm = time().@$_FILES['txtThumbnail']['name'];
			$target = $target . basename( $tm);
			$Filename=basename( $tm);
			
			@move_uploaded_file(@$_FILES['txtThumbnail']['tmp_name'], $target);
			//exit;
			
			$age_group = trim(addslashes($this->getRequest()->getPost('txtAgeGroup')));
			$video_title = trim(addslashes($this->getRequest()->getPost('txtVideoTitle')));
			//$video_thumbnail = trim($this->getRequest()->getPost('txtThumbnail'));
			$video_thumbnail = $Filename;
			$video_embed_code = trim(addslashes($this->getRequest()->getPost('txtEmbedCode')));
			$video_description = trim(addslashes($this->getRequest()->getPost('txtDescription')));
			$this->view->addResult = $dbHelper->addVideo($age_group, $video_title, $video_thumbnail, $video_embed_code, $video_description);	
			$this->view->selectedItem = 'itemVideo';
		}
	}
	
	public function deletevideoAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();	
		
		$this->_helper->layout()->disableLayout();
	    $this->_helper->viewRenderer->setNoRender(true);
		
		$catID = $this->getRequest()->getParam('catID');
		echo $dbHelper->deleteActivityCategory($catID);
	}	
	
	public function editvideoAction() {
		$this->checkActhentication();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		$this->view->ageGroups = $dbHelper->getAgeGroups();
		
		$videoID = $this->getRequest()->getParam('videoID');
		$this->view->activityCategory = $rec = $dbHelper->getVideoByID($videoID);	
		
		if($this->getRequest()->isPost()) {
			$Filename= $rec['video_thumbnail'];
			if(@$_FILES['txtThumbnail']['name']){
				$target = ABSOLUTE_URL."/assets/video/";
				$tm = time().@$_FILES['txtThumbnail']['name'];
				$target = $target . basename( $tm);
				$Filename=basename( $tm);
				
				@move_uploaded_file(@$_FILES['txtThumbnail']['tmp_name'], $target);
			}
			
			
			$age_group = trim(addslashes($this->getRequest()->getPost('txtAgeGroup')));
			$video_title = trim(addslashes($this->getRequest()->getPost('txtVideoTitle')));
			//$video_thumbnail = trim($this->getRequest()->getPost('txtThumbnail'));
			$video_thumbnail = $Filename;
			$video_embed_code = trim(addslashes($this->getRequest()->getPost('txtEmbedCode')));
			$video_description = trim(addslashes($this->getRequest()->getPost('txtDescription')));
			$catID = trim($this->getRequest()->getPost('hdnID'));
			$this->view->editResult = $dbHelper->updateVideo($age_group,$video_title,$video_thumbnail,$video_embed_code,$video_description, $catID);	
			$this->view->selectedItem = 'itemVideo';
		} else {
			
		}
	}
	
	
	public function playvideoAction() {
		$this->checkActhentication();
		$this->_helper->layout()->disableLayout();
		$dbHelper = new Application_Model_Helpers_AdminHelper();
		$this->view->ageGroups = $dbHelper->getAgeGroups();
		
		$videoID = $this->getRequest()->getParam('id');
		$this->view->activityCategory = $rec = $dbHelper->getVideoByID($videoID);	
		
			}
	
	/** Manage topic Ends **/
}

