<?php
include APPLICATION_PATH.'/services/GenericService.php';
class ServiceController extends Zend_Controller_Action {	
	private $server;	
	public function preDispatch() {
	    $this->_helper->layout()->disableLayout();
	    $this->_helper->viewRenderer->setNoRender(true);
	}

    public function init() {
        // Initiate JSON RPC Server
        $this->server = new Zend_Json_Server();
    	$this->server->setClass("GenericService");
    	//$this->server->setTarget('public/service/v1')->setEnvelope(Zend_Json_Server_Smd::ENV_JSONRPC_2);
    }

    public function indexAction() {
    	if ('GET' == $_SERVER['REQUEST_METHOD']) {
			echo "<h4>This application do not support GET request. Only POST transport is supported</h4>";
			echo "<br><a href='service/smd'>Click Here</a> to download Service Mapping Description";
			echo "<br><a href='service/smddesc'>Click Here</a> to see Service Mapping Description details";
			return;
		}
		$this->handleRequest();
	}

	public function smdAction() {
		if ('GET' == $_SERVER['REQUEST_METHOD']) {
			$smd = $this->server->getServiceMap();
    		header('Content-Type: application/json-rpc');
    		//header("Content-Disposition: attachment; filename=PollWidgetSMD.json");
    		echo $smd->toJson();
			return;
		}
	}

	public function smddescAction() {
		if ('GET' == $_SERVER['REQUEST_METHOD']) {
			include_once APPLICATION_PATH.'/utils/ServiceDesc.php';
			$serviceDesc=new ServiceDesc($this->server->getServiceMap());
			$serviceDesc->renderDescription();
			return;
		}
	}

	public function v1Action() {
		$this->server->setClass("GenericService");
    	//$this->server->setTarget('public/service/v1')->setEnvelope(Zend_Json_Server_Smd::ENV_JSONRPC_2);
    	if ('GET' == $_SERVER['REQUEST_METHOD']) {
			include_once APPLICATION_PATH.'/utils/ServiceDesc.php';
			$serviceDesc=new ServiceDesc($this->server->getServiceMap());
			$serviceDesc->renderDescription();
			return;
		}
		$this->handleRequest();
	}

	private function handleRequest() {			
		$this->server->setAutoEmitResponse(false); 
		$response=$this->server->handle();
		$jsonResponse=new Zend_Json_Server_Response();
		$jsonResponse->setVersion($response->getVersion());
		$jsonResponse->setId($response->getId());
		if($response->isError()) { 
			$jsonResponse->setError($response->getError());		
		} else {
			$jsonResponse->setResult($response->getResult());
		}
		echo $jsonResponse;
	}
}