<?php
class SettingsController extends Zend_Controller_Action {
    public function init() {		
		$ns = new Zend_Session_Namespace('PublicSite');
		$this->_helper->layout->setLayout('layout-admin');
    }	
	
	public function checkAuthentication() {
		if(!isset($_SESSION['s_member'])) {
			$this->_redirect('/index');	
		}
	}
	
	public function indexAction() {
		$this->checkAuthentication();
	}
	
	/*** Provinces ***/
	public function provincesAction() {
		$this->checkAuthentication();
		
		$db = new Application_Model_Helpers_SettingsHelper();
		$this->view->provinces = json_decode($db->fetchProvinces());
	}
	
	public function delprovinceAction() {
		$this->checkActhentication();
		$this->_helper->layout()->disableLayout();
	    $this->_helper->viewRenderer->setNoRender(true);
		$db = new Application_Model_Helpers_SettingsHelper();
		$provID = $this->getRequest()->getParam('province');
		$db->removeProvince($provID);
	}
	
	public function changeprovincestatusAction() {
		$this->checkActhentication();
		$this->_helper->layout()->disableLayout();
	    $this->_helper->viewRenderer->setNoRender(true);
		$db = new Application_Model_Helpers_SettingsHelper();
		$provID = $this->getRequest()->getParam('province');
		$currentStat = $this->getRequest()->getParam('currentStatus');
		$db->changeProvinceStatus($provID, $currentStat);
		if($currentStat==1)
			echo '0';
		else
			echo '1';
	}
	
	public function addprovinceAction() {
		$this->checkAuthentication();
		$db = new Application_Model_Helpers_SettingsHelper();
		if($this->getRequest()->isPost()) {
			$provName = trim($this->getRequest()->getParam('provinceName'));
			$provCode = trim($this->getRequest()->getParam('provinceCode'));	
			
			$arrProvince = array('provName'=>$provName, 'provCode'=>$provCode, 'provID'=>0, 'action'=>'add');
			$exists = $db->checkIfProvinceExists($arrProvince);
			$arr = array();
			if($exists) {
				$arr['status'] = 0;
				$arr['statusMsg'] = 'This province already exists. Please try another.';
			} else {
				$db->addProvince($provName, $provCode);
				$arr['status'] = 1;
				$arr['statusMsg'] = 'Province added successfully.';
			}
			$this->view->status = $arr;
		}
	}
	
	public function editprovinceAction() {
		$this->checkAuthentication();
		$db = new Application_Model_Helpers_SettingsHelper();
		$provID = $this->getRequest()->getParam('pid');
		$this->view->province = $db->getProvinceByID($provID);
		if($this->getRequest()->isPost()) {
			$provName = trim($this->getRequest()->getParam('provinceName'));
			$provCode = trim($this->getRequest()->getParam('provinceCode'));	
			
			$arrProvince = array('provName'=>$provName, 'provCode'=>$provCode, 'provID'=>$provID, 'action'=>'edit');
			$exists = $db->checkIfProvinceExists($arrProvince);
			$arr = array();
			if($exists) {
				$arr['status'] = 0;
				$arr['statusMsg'] = 'This province already exists. Please try another.';
			} else {
				$db->editProvince($provName, $provCode, $provID);
				$arr['status'] = 1;
				$arr['statusMsg'] = 'Province updated successfully.';
			}
			$this->view->status = $arr;
		}
	}
	/*** Provinces ***/
	
	/*** Departments ***/
	public function departmentsAction() {
		$this->checkAuthentication();
		$db = new Application_Model_Helpers_SettingsHelper();
		$this->view->departments = json_decode($db->fetchDepartments());
	}
	
	public function deldepartmentAction() {
		$this->checkAuthentication();
		$this->_helper->layout()->disableLayout();
	    $this->_helper->viewRenderer->setNoRender(true);
		$db = new Application_Model_Helpers_SettingsHelper();
		$deptID = $this->getRequest()->getParam('dept');
		$db->removeDepartment($deptID);
	}
	
	public function changedepartmentstatusAction() {
		$this->checkAuthentication();
		$this->_helper->layout()->disableLayout();
	    $this->_helper->viewRenderer->setNoRender(true);
		$db = new Application_Model_Helpers_SettingsHelper();
		$deptID = $this->getRequest()->getParam('dept');
		$currentStat = $this->getRequest()->getParam('currentStatus');
		$db->changeDepartmentStatus($deptID, $currentStat);
		if($currentStat==1)
			echo '0';
		else
			echo '1';
	}
	
	public function adddepartmentAction() {
		$this->checkAuthentication();
		$db = new Application_Model_Helpers_SettingsHelper();
		if($this->getRequest()->isPost()) {
			$deptName = trim($this->getRequest()->getParam('deptName'));
			
			$arrDept = array('deptName'=>$deptName, 'deptID'=>0, 'action'=>'add');
			$exists = $db->checkIfDeptExists($arrDept);
			$arr = array();
			if($exists) {
				$arr['status'] = 0;
				$arr['statusMsg'] = 'This department already exists. Please try another.';
			} else {
				$db->addDepartment($deptName);
				$arr['status'] = 1;
				$arr['statusMsg'] = 'Department added successfully.';
			}
			$this->view->status = $arr;
		}
	}
	
	public function editdepartmentAction() {
		$this->checkAuthentication();
		$db = new Application_Model_Helpers_SettingsHelper();
		$deptID = $this->getRequest()->getParam('deptid');
		$this->view->dept = $db->getDepartmentByID($deptID);
		if($this->getRequest()->isPost()) {
			$deptName = trim($this->getRequest()->getParam('deptName'));
			
			$arrDept = array('deptName'=>$deptName, 'deptID'=>$deptID, 'action'=>'edit');
			$exists = $db->checkIfDeptExists($arrDept);
			$arr = array();
			if($exists) {
				$arr['status'] = 0;
				$arr['statusMsg'] = 'This department already exists. Please try another.';
			} else {
				$db->editDepartment($deptName, $deptID);
				$arr['status'] = 1;
				$arr['statusMsg'] = 'Department updated successfully.';
			}
			$this->view->status = $arr;
		}
	}
	/*** Departments ***/
	
	/*** User Types ***/
	public function usertypesAction() {
		$this->checkAuthentication();
		$db = new Application_Model_Helpers_SettingsHelper();
		$this->view->types = json_decode($db->fetchUserTypes());
	}
	
	public function delusertypeAction() {
		$this->checkAuthentication();
		$this->_helper->layout()->disableLayout();
	    $this->_helper->viewRenderer->setNoRender(true);
		$db = new Application_Model_Helpers_SettingsHelper();
		$typeID = $this->getRequest()->getParam('type');
		$db->removeUserType($typeID);
	}
	
	public function changeusertypestatusAction() {
		$this->checkAuthentication();
		$this->_helper->layout()->disableLayout();
	    $this->_helper->viewRenderer->setNoRender(true);
		$db = new Application_Model_Helpers_SettingsHelper();
		$typeID = $this->getRequest()->getParam('type');
		$currentStat = $this->getRequest()->getParam('currentStatus');
		$db->changeUserTypeStatus($typeID, $currentStat);
		if($currentStat==1)
			echo '0';
		else
			echo '1';
	}
	
	public function addusertypeAction() {
		$this->checkAuthentication();
		$db = new Application_Model_Helpers_SettingsHelper();
		if($this->getRequest()->isPost()) {
			$typeName = trim($this->getRequest()->getParam('userTypeName'));
			
			$arrType = array('typeName'=>$typeName, 'typeID'=>0, 'action'=>'add');
			$exists = $db->checkIfUserTypeExists($arrType);
			$arr = array();
			if($exists) {
				$arr['status'] = 0;
				$arr['statusMsg'] = 'This user type already exists. Please try another.';
			} else {
				$db->addUserType($typeName);
				$arr['status'] = 1;
				$arr['statusMsg'] = 'User Type added successfully.';
			}
			$this->view->status = $arr;
		}
	}
	
	public function editusertypeAction() {
		$this->checkAuthentication();
		$db = new Application_Model_Helpers_SettingsHelper();
		$typeID = $this->getRequest()->getParam('typeid');
		$this->view->type = $db->getUserTypeByID($typeID);
		if($this->getRequest()->isPost()) {
			$typeName = trim($this->getRequest()->getParam('userTypeName'));
			
			$arrType = array('typeName'=>$typeName, 'typeID'=>$typeID, 'action'=>'edit');
			$exists = $db->checkIfUserTypeExists($arrType);
			$arr = array();
			if($exists) {
				$arr['status'] = 0;
				$arr['statusMsg'] = 'This user type already exists. Please try another.';
			} else {
				$db->editUserType($typeName, $typeID);
				$arr['status'] = 1;
				$arr['statusMsg'] = 'User Type updated successfully.';
			}
			$this->view->status = $arr;
		}
	}
	/*** User Types ***/
	
	/*** Users ***/
	public function usersAction() {
		$this->checkAuthentication();
		$db = new Application_Model_Helpers_SettingsHelper();
		
		$this->view->users = $db->getUsers();
	}
	
	public function deluserAction() {
		$this->checkAuthentication();
		$this->_helper->layout()->disableLayout();
	    $this->_helper->viewRenderer->setNoRender(true);
		$db = new Application_Model_Helpers_SettingsHelper();
		$userID = $this->getRequest()->getParam('user');
		$db->removeUser($userID);
	}
	
	public function changeuserstatusAction() {
		$this->checkAuthentication();
		$this->_helper->layout()->disableLayout();
	    $this->_helper->viewRenderer->setNoRender(true);
		$db = new Application_Model_Helpers_SettingsHelper();
		$userID = $this->getRequest()->getParam('user');
		$currentStat = $this->getRequest()->getParam('currentStatus');
		$db->changeUserStatus($userID, $currentStat);
		if($currentStat==1)
			echo '0';
		else
			echo '1';
	}
	
	public function adduserAction() {
		$this->checkAuthentication();
		$dbHelper = new Application_Model_Helpers_SettingsHelper();
		$this->view->provinces = $dbHelper->fetchActiveProvinces();
		$this->view->departments = $dbHelper->fetchActiveDepartments();
		$this->view->userTypes = $dbHelper->fetchActiveUserTypes();
		
		$db = new Application_Model_Helpers_SettingsHelper();
		if($this->getRequest()->isPost()) {
			$userName = trim($this->getRequest()->getParam('txtUsername'));
			
			$arrUserExists = array('userName'=>$userName, 'userID'=>0, 'action'=>'add');
			$exists = $db->checkIfUserExists($arrUserExists);
			$arr = array();
			if($exists) {
				$arr['status'] = 0;
				$arr['statusMsg'] = 'This username already exists. Please try another.';
			} else {
				$arrUser = array();
				$arrUser['userName'] 	= $userName;
				$arrUser['userPass'] 	= trim($this->getRequest()->getParam('txtUserPass'));
				$arrUser['fName'] 		= trim($this->getRequest()->getParam('txtFName'));
				$arrUser['lName'] 		= trim($this->getRequest()->getParam('txtLName'));
				$arrUser['address'] 	= trim($this->getRequest()->getParam('txtAddress'));
				$arrUser['city'] 		= trim($this->getRequest()->getParam('txtCity'));
				$arrUser['province'] 	= trim($this->getRequest()->getParam('selProvince'));
				$arrUser['phone'] 		= trim($this->getRequest()->getParam('txtPhone'));
				$arrUser['email'] 		= trim($this->getRequest()->getParam('txtEmail'));
				$arrUser['dept'] 		= trim($this->getRequest()->getParam('selDept'));
				$arrUser['type'] 		= trim($this->getRequest()->getParam('selType'));
				
				$db->addUser($arrUser);
				$arr['status'] = 1;
				$arr['statusMsg'] = 'User added successfully.';
			}
			$this->view->status = $arr;
		}
	}
	/*** Users ***/
}

