<?php
class UserController extends Zend_Controller_Action {
    public function init() {
		$ns = new Zend_Session_Namespace('PublicSite');
		$this->_helper->layout->setLayout('layout-admin');
    }	
	
	public function checkAuthentication() {
		if(!isset($_SESSION['s_member'])) {
			$this->_redirect('/index');	
		}
	}
	
	public function profileAction() {
		$this->checkAuthentication();
		$dbHelper = new Application_Model_Helpers_SettingsHelper();
		$this->view->provinces = $dbHelper->fetchActiveProvinces();
		if($this->getRequest()->isPost()) {
			$fname = trim($this->getRequest()->getPost('txtFirst'));
			$lname = trim($this->getRequest()->getPost('txtLast'));
			$add = trim($this->getRequest()->getPost('txtAdd1'));			
			$city = trim($this->getRequest()->getPost('txtCity'));
			$prov = $this->getRequest()->getPost('selProvince');
			$ph = trim($this->getRequest()->getPost('txtPhone'));
			$em = trim($this->getRequest()->getPost('txtEmail'));
			
			
			$arrProfile = array('id'=>$_SESSION['s_member']['usr_id'], 'fname'=>$fname, 'lname'=>$lname, 'add'=>$add, 'city'=>$city, 'province'=>$prov, 'phone'=>$ph, 'email'=>$em);
			$db = new Application_Model_Helper();
			$db->saveProfile($arrProfile);
			
			$_SESSION['s_member'] = $db->getUserInfoByID($_SESSION['s_member']['usr_id']);
			$this->view->statusMsg = 'Profile updated successfully.';
		}
	}
	
	public function changepasswordAction() {
		$this->checkAuthentication();
		if($this->getRequest()->isPost()) {
			$curPass = trim($this->getRequest()->getPost('txtCurrent'));
			$newPass = trim($this->getRequest()->getPost('txtNew'));
			$conPass = trim($this->getRequest()->getPost('txtConfirm')); 
			
			$db = new Application_Model_Helper();
			$checkCurrentPass = $db->checkCurrentPass($_SESSION['s_member']['usr_id'], $curPass);
			
			$arr = array();
			if(!$checkCurrentPass) {
				$arr['status'] = 0;
				$arr['statusMsg'] = 'The current password you provided is not matching with our records. Please try again.';
			} else {
				$db->changePassword($_SESSION['s_member']['usr_id'], $newPass);
				$arr['status'] = 1;
				$arr['statusMsg'] = 'Password changed successfully.';
			}
			$this->view->status = $arr;
		}
	} 
}

