<?php
class Application_Model_Helpers_CmsHelper {
	
	var $db;
	public function Application_Model_Helpers_CmsHelper() {
		$this->db = Zend_Registry::get(DATABASE_SCHEMA);
	}
	/** FAQ Functions Start here **/
	public function fetchFAQs() {
		$query = 'SELECT f.*, CONCAT(a.adm_fname, " ", a.adm_lname) AS faq_added_by FROM kap_faq f, kap_admin a WHERE a.adm_id=f.faq_adm_id';
		return $this->db->query($query)->fetchAll();
	}
	
	public function addFAQ($arrFAQ) {
		$query = 'INSERT INTO kap_faq(faq_title, faq_details, faq_adm_id, faq_date_time, faq_status) VALUES ("'.htmlspecialchars($arrFAQ['title']).'", "'.htmlspecialchars($arrFAQ['details']).'", '.$arrFAQ['adm_id'].', NOW(), "'.$arrFAQ['status'].'")';
		if($this->db->query($query)) {
			return 1;	
		} else {
			return 0;	
		}
	}
	
	public function deleteFAQ($faqID) {
		$query = 'DELETE FROM kap_faq WHERE faq_id='.$faqID;
		if($this->db->query($query)) {
			return 1;	
		} else {
			return 0;	
		}	
	}
	
	public function getFAQDetail($faqID) {
		$query = 'SELECT * FROM kap_faq WHERE faq_id='.$faqID;
		return $this->db->query($query)->fetch();	
	}
	
	public function updateFAQ($arrFAQ) {
		$query = 'UPDATE kap_faq SET faq_title="'.htmlspecialchars($arrFAQ['title']).'", faq_details="'.htmlspecialchars($arrFAQ['details']).'", faq_status="'.$arrFAQ['status'].'" WHERE faq_id='.$arrFAQ['faqID'];
		if($this->db->query($query)) {
			return 1;	
		} else {
			return 0;	
		}		
	}
	/** FAQ Functions End here **/
	
	/** Page Functions Start here **/
	public function listPages() {
		$query = 'SELECT p.*, CONCAT(a.adm_fname, " ", a.adm_lname) AS pg_last_modified_by FROM kap_pages p, kap_admin a WHERE a.adm_id=p.pg_last_updated_by ORDER BY p.pg_title';
		return $this->db->query($query)->fetchAll();
	}
	
	public function deletePage($pageID) {
		$query = 'DELETE FROM kap_pages WHERE pg_id='.$pageID;
		if($this->db->query($query)) {
			return 1;	
		} else {
			return 0;	
		}
	}
	
	public function addPage($arrPage) {
		$query = 'INSERT INTO kap_pages(pg_title, pg_content, pg_meta_title, pg_meta_keywords, pg_meta_description, pg_status, pg_last_updated_by, pg_last_updated_on) VALUES ("'.htmlspecialchars($arrPage['title']).'", "'.htmlspecialchars($arrPage['details']).'", "'.htmlspecialchars($arrPage['metaTitle']).'", "'.htmlspecialchars($arrPage['metaKeywords']).'", "'.htmlspecialchars($arrPage['metaDescription']).'", "'.$arrPage['status'].'", '.$arrPage['adm_id'].', NOW())';
		if($this->db->query($query)) {
			return 1;	
		} else {
			return 0;	
		}
	}
	
	public function getPageDetails($pageID) {
		$query = 'SELECT * FROM kap_pages WHERE pg_id='.$pageID;
		return $this->db->query($query)->fetch();
	}
	
	public function updatePage($arrPage) {
		$query = 'UPDATE kap_pages SET pg_title="'.htmlspecialchars($arrPage['title']).'", pg_content="'.htmlspecialchars($arrPage['details']).'", pg_meta_title="'.htmlspecialchars($arrPage['metaTitle']).'", pg_meta_keywords="'.htmlspecialchars($arrPage['metaKeywords']).'", pg_meta_description="'.htmlspecialchars($arrPage['metaDescription']).'", pg_status="'.$arrPage['status'].'", pg_last_updated_by='.$arrPage['adm_id'].', pg_last_updated_on=NOW() WHERE pg_id='.$arrPage['pageID'];
		if($this->db->query($query)) {
			return 1;	
		} else {
			return 0;	
		}
	}
	/** Page Functions End here **/
}
?>