<?php
class Application_Model_Helpers_SettingsHelper {
	
	var $db;
	public function Application_Model_Helpers_SettingsHelper() {
		$this->db = Zend_Registry::get(DATABASE_SCHEMA);
	}
	/*** Provinces ***/
	public function fetchProvinces() {
		$sql = 'SELECT * FROM provinces ORDER BY provinces_name';
		$result = $this->db->query($sql)->fetchAll();
		return json_encode($result);
	}	
	
	public function fetchActiveProvinces() {
		$sql = 'SELECT * FROM provinces WHERE provinces_status=1 ORDER BY provinces_name';
		$result = $this->db->query($sql)->fetchAll();
		return $result;
	}
	
	public function removeProvince($provID) {
		$sql = 'DELETE FROM provinces WHERE provinces_id='.$provID;
		$this->db->query($sql);
	}

	public function changeProvinceStatus($provID, $currentStat) {
		if($currentStat==1)
			$newStatus = 0;
		else
			$newStatus = 1;
		$sql = 'UPDATE provinces SET provinces_status='.$newStatus.', last_modified_by='.$_SESSION['s_member']['usr_id'].', last_modified_on=NOW() WHERE provinces_id='.$provID;
		$this->db->query($sql);
	}
	
	public function checkIfProvinceExists($prov) {
		if($prov['action']=='add') {
			$sql = 'SELECT COUNT(*) AS recordCount FROM provinces WHERE provinces_code="'.$prov['provCode'].'" OR provinces_name="'.$prov['provName'].'"';
		} else {
			$sql = 'SELECT COUNT(*) AS recordCount FROM provinces WHERE (provinces_code="'.$prov['provCode'].'" OR provinces_name="'.$prov['provName'].'") AND provinces_id!='.$prov['provID'];
		}
		$record = $this->db->query($sql)->fetch();
		if($record['recordCount']==1) //Province exists
			return true;
		else
			return false;
	}
	
	public function addProvince($prName, $prCode) {
		$userID = $_SESSION['s_member']['usr_id'];
		
		$sql = 'INSERT INTO provinces (provinces_name, provinces_code, add_by, add_on, last_modified_by, last_modified_on) VALUES ("'.$prName.'", "'.$prCode.'", '.$userID.', NOW(), '.$userID.', NOW())';
		$this->db->query($sql);
	}
	
	public function getProvinceByID($provID) {
		$sql = 'SELECT * FROM provinces WHERE provinces_id='.$provID;
		
		return $this->db->query($sql)->fetch();
	}
	
	public function editProvince($provName, $provCode, $provID) {
		$userID = $_SESSION['s_member']['usr_id'];
		$sql = 'UPDATE provinces SET provinces_name="'.$provName.'", provinces_code="'.$provCode.'", last_modified_by='.$userID.', last_modified_on=NOW() WHERE provinces_id='.$provID;
		$this->db->query($sql);
	}
	/*** Provinces ***/
	
	/*** Departments ***/
	public function fetchDepartments() {
		$sql = 'SELECT * FROM departments ORDER BY dept_name';
		$result = $this->db->query($sql)->fetchAll();
		return json_encode($result);
	}	
	
	public function fetchActiveDepartments() {
		$sql = 'SELECT * FROM departments WHERE dept_status=1 ORDER BY dept_name';
		$result = $this->db->query($sql)->fetchAll();
		return $result;
	}
	
	public function removeDepartment($deptID) {
		$sql = 'DELETE FROM departments WHERE dept_id='.$deptID;
		$this->db->query($sql);
	}
	
	public function changeDepartmentStatus($deptID, $currentStat) {
		if($currentStat==1)
			$newStatus = 0;
		else
			$newStatus = 1;
		$sql = 'UPDATE departments SET dept_status='.$newStatus.', last_updated_by='.$_SESSION['s_member']['usr_id'].', last_updated_on=NOW() WHERE dept_id='.$deptID;
		$this->db->query($sql);
	}
	
	public function checkIfDeptExists($dept) {
		if($dept['action']=='add') {
			$sql = 'SELECT COUNT(*) AS recordCount FROM departments WHERE dept_name="'.$dept['deptName'].'"';
		} else {
			$sql = 'SELECT COUNT(*) AS recordCount FROM departments WHERE dept_name="'.$dept['deptName'].'" AND dept_id!='.$dept['deptID'];
		}
		$record = $this->db->query($sql)->fetch();
		if($record['recordCount']==1) //Department exists
			return true;
		else
			return false;
	}
	
	public function addDepartment($deptName) {
		$userID = $_SESSION['s_member']['usr_id'];
		
		$sql = 'INSERT INTO departments (dept_name, added_by, add_on, last_updated_by, last_updated_on) VALUES ("'.$deptName.'", '.$userID.', NOW(), '.$userID.', NOW())';
		$this->db->query($sql);
	}
	
	public function getDepartmentByID($deptID) {
		$sql = 'SELECT * FROM departments WHERE dept_id='.$deptID;
		
		return $this->db->query($sql)->fetch();
	}
	
	public function editDepartment($deptName, $deptID) {
		$userID = $_SESSION['s_member']['usr_id'];
		$sql = 'UPDATE departments SET dept_name="'.$deptName.'", last_updated_by='.$userID.', last_updated_on=NOW() WHERE dept_id='.$deptID;
		$this->db->query($sql);
	}
	/*** Departments ***/
	
	/*** User Types ***/
	public function fetchUserTypes() {
		$sql = 'SELECT * FROM user_types ORDER BY type_name';
		$result = $this->db->query($sql)->fetchAll();
		return json_encode($result);
	}
	
	public function fetchActiveUserTypes() {
		$sql = 'SELECT * FROM user_types WHERE type_status=1 ORDER BY type_name';
		$result = $this->db->query($sql)->fetchAll();
		return $result;
	}
	
	public function removeUserType($typeID) {
		$sql = 'DELETE FROM user_types WHERE type_id='.$typeID;
		$this->db->query($sql);
	}
	
	public function changeUserTypeStatus($typeID, $currentStat) {
		if($currentStat==1)
			$newStatus = 0;
		else
			$newStatus = 1;
		$sql = 'UPDATE user_types SET type_status='.$newStatus.', last_updated_by='.$_SESSION['s_member']['usr_id'].', last_updated_on=NOW() WHERE type_id='.$typeID;
		$this->db->query($sql);
	}
	
	public function checkIfUserTypeExists($type) {
		if($type['action']=='add') {
			$sql = 'SELECT COUNT(*) AS recordCount FROM user_types WHERE type_name="'.$type['typeName'].'"';
		} else {
			$sql = 'SELECT COUNT(*) AS recordCount FROM user_types WHERE type_name="'.$type['typeName'].'" AND type_id!='.$type['typeID'];
		}
		$record = $this->db->query($sql)->fetch();
		if($record['recordCount']==1) //User Type exists
			return true;
		else
			return false;
	}
	
	public function addUserType($typeName) {
		$userID = $_SESSION['s_member']['usr_id'];
		
		$sql = 'INSERT INTO user_types (type_name, added_by, added_on, last_updated_by, last_updated_on) VALUES ("'.$typeName.'", '.$userID.', NOW(), '.$userID.', NOW())';
		$this->db->query($sql);
	}
	
	public function getUserTypeByID($typeID) {
		$sql = 'SELECT * FROM user_types WHERE type_id='.$typeID;
		
		return $this->db->query($sql)->fetch();
	}
	
	public function editUserType($typeName, $typeID) {
		$userID = $_SESSION['s_member']['usr_id'];
		$sql = 'UPDATE user_types SET type_name="'.$typeName.'", last_updated_by='.$userID.', last_updated_on=NOW() WHERE type_id='.$typeID;
		$this->db->query($sql);
	}
	/*** User Types ***/
	
	/*** Users ***/
	public function getUsers() {
		$sql = 'SELECT u.*, d.dept_name, t.type_name FROM users u, departments d, user_types t WHERE d.dept_id=u.usr_dept_id AND t.type_id=u.usr_type ORDER BY u.usr_fname, u.usr_lname';
		$userResult = $this->db->query($sql)->fetchAll();
		$arrUsers = array();
		for($i=0; $i<count($userResult); $i++) {
			$arrUsers[$i]['usr_id'] = $userResult[$i]['usr_id'];
			$arrUsers[$i]['usr_name'] = $userResult[$i]['usr_name'];
			$arrUsers[$i]['usr_full_name'] = $userResult[$i]['usr_fname'].' '.$userResult[$i]['usr_lname'];
			$arrUsers[$i]['usr_city'] = $userResult[$i]['usr_city'];
			$arrUsers[$i]['usr_phone'] = $userResult[$i]['usr_phone'];
			$arrUsers[$i]['usr_dept'] = $userResult[$i]['dept_name'];
			$arrUsers[$i]['usr_role'] = $userResult[$i]['type_name'];			
			$arrUsers[$i]['usr_status'] = $userResult[$i]['usr_status'];
		}
		return $arrUsers;
	}
	
	public function removeUser($userID) {
		$sql = 'DELETE FROM users WHERE usr_id='.$userID;
		$this->db->query($sql);
	}
	
	public function changeUserStatus($userID, $currentStat) {
		if($currentStat==1)
			$newStatus = 0;
		else
			$newStatus = 1;
		$sql = 'UPDATE users SET usr_status='.$newStatus.', usr_last_updated_by='.$_SESSION['s_member']['usr_id'].', usr_last_updated_on=NOW() WHERE usr_id='.$userID;
		$this->db->query($sql);
	}
	
	public function checkIfUserExists($user) {
		if($user['action']=='add') {
			$sql = 'SELECT COUNT(*) AS recordCount FROM users WHERE usr_name="'.$user['userName'].'"';
		} else {
			$sql = 'SELECT COUNT(*) AS recordCount FROM users WHERE usr_name="'.$user['userName'].'" AND usr_id!='.$type['userID'];
		}
		$record = $this->db->query($sql)->fetch();
		if($record['recordCount']==1) //Username exists
			return true;
		else
			return false;
	}
	
	public function addUser($user) {
		$sql = 'INSERT INTO users (usr_name, usr_pass, usr_fname, usr_lname, usr_address, usr_city, usr_province, usr_phone, usr_email, usr_dept_id, usr_type, usr_added_by, usr_added_on, usr_last_updated_by, usr_last_updated_on) VALUES ("';
		$sql.= $user['userName'].'", "'.md5($user['userPass']).'", "'.$user['fName'].'", "'.$user['lName'].'", "'.$user['address'].'", "'.$user['city'].'", "'.$user['province'].'", "'.$user['phone'].'", "'.$user['email'].'", '.$user['dept'].', '.$user['type'].', '.$_SESSION['s_member']['usr_id'].', NOW(), '.$_SESSION['s_member']['usr_id'].', NOW())';
		
		$this->db->query($sql);
	}
	/*** Users ***/
}
?>