<?php
// Define path to application directory
defined('APPLICATION_PATH')
    || define('APPLICATION_PATH', realpath(dirname(__FILE__) . '/application'));

// Define application environment
defined('APPLICATION_ENV')
    || define('APPLICATION_ENV', (getenv('APPLICATION_ENV') ? getenv('APPLICATION_ENV') : 'development'));

define('DATABASE_SCHEMA','DB');

define('SITE_TITLE', "Kids' Learning Point");
define('ABSOLUTE_URL', 'e:/xampp/htdocs/klp/');
//define('ABSOLUTE_URL', getcwd());

define('WEB_SERVER_ROOT', 'http://localhost:8080/klp/');
//define('WEB_SERVER_ROOT', 'http://kidsactivitypoint.com/');
// Ensure library/ is on include_path
set_include_path(implode(PATH_SEPARATOR, array(
    realpath(APPLICATION_PATH . '/../library'),
	realpath(APPLICATION_PATH . '/utils'),
    get_include_path(),
)));

/** Zend_Application */
require_once 'Zend/Application.php';

// Create application, bootstrap, and run
$application = new Zend_Application(
    APPLICATION_ENV,
    APPLICATION_PATH . '/configs/application.ini'
);

// Create registry object and setting it as the static instance in the Zend_Registry class	
$registry = new Zend_Registry();
Zend_Registry::setInstance($registry);
 
// Load configuration file and store the data in the registry
$configuration = new Zend_Config_Ini(APPLICATION_PATH . '/configs/application.ini', APPLICATION_ENV);
Zend_Registry::set('config', $configuration);
$application->bootstrap()->run();